/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xobj;

import uk.co.demon.obelisk.xobj.Expr;
import uk.co.demon.obelisk.xobj.Section;
import uk.co.demon.obelisk.xobj.SectionMap;
import uk.co.demon.obelisk.xobj.SymbolMap;

public abstract class UnaryExpr
extends Expr {
    protected final Expr exp;

    public final Expr getExp() {
        return this.exp;
    }

    public final boolean isAbsolute() {
        return this.exp.isAbsolute();
    }

    public final boolean isExternal(Section section) {
        return this.exp.isExternal(section);
    }

    public abstract long resolve(SectionMap var1, SymbolMap var2);

    protected UnaryExpr(Expr exp) {
        this.exp = exp;
    }

    public static class Cpl
    extends UnaryExpr {
        public Cpl(Expr exp) {
            super(exp);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.exp.resolve(sections, symbols) ^ 0xFFFFFFFFFFFFFFFFL;
        }

        public String toString() {
            return "<cpl>" + this.exp + "</cpl>";
        }
    }

    public static class Neg
    extends UnaryExpr {
        public Neg(Expr exp) {
            super(exp);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return -this.exp.resolve(sections, symbols);
        }

        public String toString() {
            return "<neg>" + this.exp + "</neg>";
        }
    }

    public static class Not
    extends UnaryExpr {
        public Not(Expr exp) {
            super(exp);
        }

        public long resolve(SectionMap sections, SymbolMap symbols) {
            return this.exp.resolve(sections, symbols) != 0L ? 0 : 1;
        }

        public String toString() {
            return "<not>" + this.exp + "</not>";
        }
    }
}

